export interface Post {
  id: string
  title: string
  slug: string
  content: string
  excerpt: string
  featuredImage: string
  authorId: string
  authorName: string
  authorAvatar: string
  categoryId: string
  categoryName: string
  status: "draft" | "published" | "archived"
  views: number
  publishedAt: string
  createdAt: string
  likes: number
}

export interface Category {
  id: string
  name: string
  slug: string
  description: string
  postCount: number
}

export interface Comment {
  id: string
  postId: string
  userId: string
  userName: string
  userAvatar: string
  content: string
  parentId?: string
  createdAt: string
  replies?: Comment[]
}

export const mockCategories: Category[] = [
  {
    id: "1",
    name: "Technology",
    slug: "technology",
    description: "Latest tech trends and innovations",
    postCount: 12,
  },
  {
    id: "2",
    name: "Design",
    slug: "design",
    description: "UI/UX and creative design insights",
    postCount: 8,
  },
  {
    id: "3",
    name: "Business",
    slug: "business",
    description: "Business strategies and entrepreneurship",
    postCount: 15,
  },
  {
    id: "4",
    name: "Lifestyle",
    slug: "lifestyle",
    description: "Life, wellness, and personal growth",
    postCount: 10,
  },
]

export const mockPosts: Post[] = [
  {
    id: "1",
    title: "The Future of Artificial Intelligence in Web Development",
    slug: "future-of-ai-web-development",
    content: "<p>Artificial intelligence is revolutionizing how we build and interact with websites...</p>",
    excerpt: "Explore how AI is transforming the landscape of modern web development and what it means for developers.",
    featuredImage: "/ai-futuristic-city.png",
    authorId: "1",
    authorName: "Sarah Johnson",
    authorAvatar: "/professional-woman-diverse.png",
    categoryId: "1",
    categoryName: "Technology",
    status: "published",
    views: 1234,
    publishedAt: "2024-01-15T10:00:00Z",
    createdAt: "2024-01-15T10:00:00Z",
    likes: 45,
  },
  {
    id: "2",
    title: "Mastering Minimalist Design Principles",
    slug: "mastering-minimalist-design",
    content: "<p>Less is more when it comes to creating impactful user experiences...</p>",
    excerpt: "Learn the core principles of minimalist design and how to apply them to create stunning interfaces.",
    featuredImage: "/minimalist-design-clean.jpg",
    authorId: "2",
    authorName: "Michael Chen",
    authorAvatar: "/professional-man.jpg",
    categoryId: "2",
    categoryName: "Design",
    status: "published",
    views: 892,
    publishedAt: "2024-01-14T14:30:00Z",
    createdAt: "2024-01-14T14:30:00Z",
    likes: 32,
  },
  {
    id: "3",
    title: "Building a Successful Startup in 2024",
    slug: "building-successful-startup-2024",
    content: "<p>The startup landscape has evolved dramatically in recent years...</p>",
    excerpt:
      "Essential strategies and insights for launching and scaling your startup in the modern business environment.",
    featuredImage: "/startup-business-office.jpg",
    authorId: "3",
    authorName: "Emily Rodriguez",
    authorAvatar: "/confident-business-woman.png",
    categoryId: "3",
    categoryName: "Business",
    status: "published",
    views: 2156,
    publishedAt: "2024-01-13T09:15:00Z",
    createdAt: "2024-01-13T09:15:00Z",
    likes: 67,
  },
  {
    id: "4",
    title: "The Art of Work-Life Balance",
    slug: "art-of-work-life-balance",
    content: "<p>Finding harmony between professional ambitions and personal wellbeing...</p>",
    excerpt: "Practical tips and mindset shifts to achieve a healthier balance between work and personal life.",
    featuredImage: "/peaceful-lifestyle-balance.jpg",
    authorId: "1",
    authorName: "Sarah Johnson",
    authorAvatar: "/professional-woman-diverse.png",
    categoryId: "4",
    categoryName: "Lifestyle",
    status: "published",
    views: 1567,
    publishedAt: "2024-01-12T16:45:00Z",
    createdAt: "2024-01-12T16:45:00Z",
    likes: 89,
  },
  {
    id: "5",
    title: "Next.js 15: What's New and Exciting",
    slug: "nextjs-15-whats-new",
    content: "<p>The latest version of Next.js brings powerful new features...</p>",
    excerpt: "A comprehensive overview of the new features and improvements in Next.js 15.",
    featuredImage: "/nextjs-coding-development.jpg",
    authorId: "2",
    authorName: "Michael Chen",
    authorAvatar: "/professional-man.jpg",
    categoryId: "1",
    categoryName: "Technology",
    status: "published",
    views: 3421,
    publishedAt: "2024-01-11T11:20:00Z",
    createdAt: "2024-01-11T11:20:00Z",
    likes: 124,
  },
  {
    id: "6",
    title: "Color Theory for Digital Designers",
    slug: "color-theory-digital-designers",
    content: "<p>Understanding color psychology and application in digital design...</p>",
    excerpt: "Master the fundamentals of color theory to create visually harmonious and effective designs.",
    featuredImage: "/color-palette-design.png",
    authorId: "3",
    authorName: "Emily Rodriguez",
    authorAvatar: "/confident-business-woman.png",
    categoryId: "2",
    categoryName: "Design",
    status: "published",
    views: 1876,
    publishedAt: "2024-01-10T13:00:00Z",
    createdAt: "2024-01-10T13:00:00Z",
    likes: 56,
  },
]

export const mockComments: Comment[] = [
  {
    id: "1",
    postId: "1",
    userId: "2",
    userName: "Michael Chen",
    userAvatar: "/professional-man.jpg",
    content: "Great article! AI is definitely changing the game for web developers.",
    createdAt: "2024-01-15T12:30:00Z",
  },
  {
    id: "2",
    postId: "1",
    userId: "3",
    userName: "Emily Rodriguez",
    userAvatar: "/confident-business-woman.png",
    content: "I've been experimenting with AI tools in my workflow. The productivity gains are incredible!",
    createdAt: "2024-01-15T14:15:00Z",
  },
]
