"use client"

import { Badge } from "@/components/ui/badge"
import { mockCategories } from "@/lib/mock-data"

interface CategoryFilterProps {
  selectedCategory: string | null
  onSelectCategory: (categoryId: string | null) => void
}

export function CategoryFilter({ selectedCategory, onSelectCategory }: CategoryFilterProps) {
  return (
    <div className="flex flex-wrap gap-2">
      <Badge
        variant={selectedCategory === null ? "default" : "outline"}
        className="cursor-pointer hover:bg-primary hover:text-primary-foreground transition-colors"
        onClick={() => onSelectCategory(null)}
      >
        All Posts
      </Badge>
      {mockCategories.map((category) => (
        <Badge
          key={category.id}
          variant={selectedCategory === category.id ? "default" : "outline"}
          className="cursor-pointer hover:bg-primary hover:text-primary-foreground transition-colors"
          onClick={() => onSelectCategory(category.id)}
        >
          {category.name} ({category.postCount})
        </Badge>
      ))}
    </div>
  )
}
