import Link from "next/link"
import { Badge } from "@/components/ui/badge"
import { mockCategories } from "@/lib/mock-data"

interface CategoryFilterLinksProps {
  selectedCategory: string | null
}

export function CategoryFilterLinks({ selectedCategory }: CategoryFilterLinksProps) {
  return (
    <div className="flex flex-wrap gap-2">
      <Link href={{ pathname: "/", query: {} }}>
        <Badge
          variant={selectedCategory === null ? "default" : "outline"}
          className="cursor-pointer hover:bg-primary hover:text-primary-foreground transition-colors"
        >
          All Posts
        </Badge>
      </Link>
      {mockCategories.map((category) => {
        const isSelected = selectedCategory === category.id
        return (
          <Link key={category.id} href={{ pathname: "/", query: { category: category.id } }}>
            <Badge
              variant={isSelected ? "default" : "outline"}
              className="cursor-pointer hover:bg-primary hover:text-primary-foreground transition-colors"
            >
              {category.name} ({category.postCount})
            </Badge>
          </Link>
        )
      })}
    </div>
  )
}


