import Link from "next/link"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"

interface AuthorCardProps {
  name: string
  avatar: string
  bio?: string
}

export function AuthorCard({ name, avatar, bio }: AuthorCardProps) {
  return (
    <Card>
      <CardContent className="p-6">
        <div className="flex items-start gap-4">
          <Avatar className="h-16 w-16">
            <AvatarImage src={avatar || "/placeholder.svg"} alt={name} />
            <AvatarFallback>{name.charAt(0)}</AvatarFallback>
          </Avatar>
          <div className="flex-1">
            <h3 className="font-semibold text-lg mb-1">{name}</h3>
            <p className="text-sm text-muted-foreground mb-4 leading-relaxed">
              {bio || "Passionate writer sharing insights and stories with the community."}
            </p>
            <Button variant="outline" size="sm" asChild>
              <Link href={`/author/${name.toLowerCase().replace(" ", "-")}`}>View Profile</Link>
            </Button>
          </div>
        </div>
      </CardContent>
    </Card>
  )
}
