"use client"

import Link from "next/link"
import { Header } from "@/components/layout/header"
import { Footer } from "@/components/layout/footer"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { mockCategories, mockPosts } from "@/lib/mock-data"
import { ArrowRight, Folder } from "lucide-react"

export default function CategoriesPage() {
  return (
    <div className="min-h-screen flex flex-col">
      <Header />

      <main className="flex-1">
        {/* Hero Section */}
        <section className="bg-gradient-to-br from-primary/5 via-accent/5 to-background py-16 md:py-24">
          <div className="container mx-auto px-4">
            <div className="max-w-3xl mx-auto text-center space-y-4">
              <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-medium">
                <Folder className="h-4 w-4" />
                Browse by Category
              </div>
              <h1 className="text-4xl md:text-5xl font-bold text-balance">Explore Topics</h1>
              <p className="text-lg text-muted-foreground leading-relaxed">
                Discover content organized by your interests and passions
              </p>
            </div>
          </div>
        </section>

        {/* Categories Grid */}
        <section className="container mx-auto px-4 py-16">
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-5xl mx-auto">
            {mockCategories.map((category) => {
              const categoryPosts = mockPosts.filter((p) => p.categoryId === category.id).slice(0, 3)

              return (
                <Card key={category.id} className="hover:shadow-lg transition-shadow">
                  <CardHeader>
                    <div className="flex items-start justify-between mb-2">
                      <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
                        <Folder className="h-6 w-6 text-primary" />
                      </div>
                      <Badge variant="secondary">{category.postCount} posts</Badge>
                    </div>
                    <CardTitle className="text-2xl">{category.name}</CardTitle>
                    <CardDescription className="text-base">{category.description}</CardDescription>
                  </CardHeader>
                  <CardContent className="space-y-4">
                    <div className="space-y-2">
                      <p className="text-sm font-medium text-muted-foreground">Recent posts:</p>
                      {categoryPosts.map((post) => (
                        <Link
                          key={post.id}
                          href={`/post/${post.slug}`}
                          className="block text-sm hover:text-primary transition-colors line-clamp-1"
                        >
                          • {post.title}
                        </Link>
                      ))}
                    </div>
                    <Link
                      href={`/?category=${category.id}`}
                      className="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline"
                    >
                      View all posts
                      <ArrowRight className="h-4 w-4" />
                    </Link>
                  </CardContent>
                </Card>
              )
            })}
          </div>
        </section>

        {/* CTA Section */}
        <section className="bg-muted/30 py-16">
          <div className="container mx-auto px-4">
            <div className="max-w-2xl mx-auto text-center space-y-6">
              <h2 className="text-3xl md:text-4xl font-bold text-balance">Can't find what you're looking for?</h2>
              <p className="text-muted-foreground leading-relaxed">
                Use our search feature to find specific topics or browse all posts on the homepage.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Link href="/">
                  <button className="px-6 py-3 bg-primary text-primary-foreground rounded-lg font-medium hover:opacity-90 transition-opacity">
                    Browse All Posts
                  </button>
                </Link>
              </div>
            </div>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  )
}
