"use client"

import { useState } from "react"
import { LoginForm } from "@/components/auth/login-form"
import { SignupForm } from "@/components/auth/signup-form"

export default function AuthPage() {
  const [mode, setMode] = useState<"login" | "signup">("login")

  return (
    <div className="min-h-screen flex items-center justify-center bg-gradient-to-br from-background via-muted/20 to-background p-4">
      <div className="w-full max-w-md">
        {mode === "login" ? (
          <LoginForm onToggleMode={() => setMode("signup")} />
        ) : (
          <SignupForm onToggleMode={() => setMode("login")} />
        )}
      </div>
    </div>
  )
}
