import { Header } from "@/components/layout/header"
import { Footer } from "@/components/layout/footer"
import { Button } from "@/components/ui/button"
import { Card } from "@/components/ui/card"
import { Users, Target, Heart, Zap } from "lucide-react"
import Image from "next/image"
import Link from "next/link"

export default function AboutPage() {
  return (
    <div className="min-h-screen flex flex-col">
      <Header />

      <main className="flex-1">
        {/* Hero Section */}
        <section className="bg-gradient-to-br from-primary/5 via-accent/5 to-background py-16 md:py-24">
          <div className="container mx-auto px-4">
            <div className="max-w-3xl mx-auto text-center space-y-6">
              <h1 className="text-4xl md:text-6xl font-bold text-balance">
                About <span className="text-primary">Insight</span>
              </h1>
              <p className="text-lg md:text-xl text-muted-foreground leading-relaxed text-pretty">
                We're building a community where ideas flourish, stories inspire, and knowledge is shared freely.
              </p>
            </div>
          </div>
        </section>

        {/* Mission Section */}
        <section className="container mx-auto px-4 py-16 md:py-24">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-medium">
                <Target className="h-4 w-4" />
                Our Mission
              </div>
              <h2 className="text-3xl md:text-4xl font-bold text-balance">Empowering Voices, Sharing Knowledge</h2>
              <p className="text-muted-foreground leading-relaxed">
                Insight was founded with a simple belief: everyone has a story worth telling. We created this platform
                to give writers a beautiful space to share their expertise, experiences, and perspectives with the
                world.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Whether you're a seasoned professional, an aspiring writer, or simply someone with valuable insights to
                share, Insight provides the tools and community to help your voice be heard.
              </p>
              <Link href="/auth">
                <Button size="lg" className="mt-4">
                  Join Our Community
                </Button>
              </Link>
            </div>
            <div className="relative h-[400px] rounded-2xl overflow-hidden">
              <Image src="/startup-business-office.jpg" alt="Team collaboration" fill className="object-cover" />
            </div>
          </div>
        </section>

        {/* Values Section */}
        <section className="bg-muted/30 py-16 md:py-24">
          <div className="container mx-auto px-4">
            <div className="text-center mb-12">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Core Values</h2>
              <p className="text-muted-foreground max-w-2xl mx-auto">
                These principles guide everything we do and shape the community we're building together.
              </p>
            </div>

            <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
              <Card className="p-6 space-y-4 hover:shadow-lg transition-shadow">
                <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
                  <Users className="h-6 w-6 text-primary" />
                </div>
                <h3 className="text-xl font-bold">Community First</h3>
                <p className="text-muted-foreground text-sm leading-relaxed">
                  We believe in fostering meaningful connections and supporting each other's growth.
                </p>
              </Card>

              <Card className="p-6 space-y-4 hover:shadow-lg transition-shadow">
                <div className="h-12 w-12 rounded-lg bg-accent/10 flex items-center justify-center">
                  <Heart className="h-6 w-6 text-accent" />
                </div>
                <h3 className="text-xl font-bold">Authenticity</h3>
                <p className="text-muted-foreground text-sm leading-relaxed">
                  Real stories, genuine perspectives, and honest conversations create lasting impact.
                </p>
              </Card>

              <Card className="p-6 space-y-4 hover:shadow-lg transition-shadow">
                <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
                  <Zap className="h-6 w-6 text-primary" />
                </div>
                <h3 className="text-xl font-bold">Innovation</h3>
                <p className="text-muted-foreground text-sm leading-relaxed">
                  We continuously improve our platform to provide the best writing and reading experience.
                </p>
              </Card>

              <Card className="p-6 space-y-4 hover:shadow-lg transition-shadow">
                <div className="h-12 w-12 rounded-lg bg-accent/10 flex items-center justify-center">
                  <Target className="h-6 w-6 text-accent" />
                </div>
                <h3 className="text-xl font-bold">Quality</h3>
                <p className="text-muted-foreground text-sm leading-relaxed">
                  We prioritize thoughtful, well-crafted content that provides real value to readers.
                </p>
              </Card>
            </div>
          </div>
        </section>

        {/* Team Section */}
        <section className="container mx-auto px-4 py-16 md:py-24">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Meet Our Team</h2>
            <p className="text-muted-foreground max-w-2xl mx-auto">
              Passionate individuals dedicated to creating the best blogging experience.
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8 max-w-4xl mx-auto">
            <Card className="p-6 text-center space-y-4">
              <div className="relative h-32 w-32 mx-auto rounded-full overflow-hidden">
                <Image src="/professional-woman-diverse.png" alt="Sarah Johnson" fill className="object-cover" />
              </div>
              <div>
                <h3 className="text-xl font-bold">Sarah Johnson</h3>
                <p className="text-sm text-primary">Founder & CEO</p>
              </div>
              <p className="text-sm text-muted-foreground leading-relaxed">
                Former tech journalist with a passion for democratizing content creation.
              </p>
            </Card>

            <Card className="p-6 text-center space-y-4">
              <div className="relative h-32 w-32 mx-auto rounded-full overflow-hidden">
                <Image src="/professional-man.jpg" alt="Michael Chen" fill className="object-cover" />
              </div>
              <div>
                <h3 className="text-xl font-bold">Michael Chen</h3>
                <p className="text-sm text-primary">Head of Product</p>
              </div>
              <p className="text-sm text-muted-foreground leading-relaxed">
                Product designer focused on creating intuitive and delightful user experiences.
              </p>
            </Card>

            <Card className="p-6 text-center space-y-4">
              <div className="relative h-32 w-32 mx-auto rounded-full overflow-hidden">
                <Image src="/confident-business-woman.png" alt="Emily Rodriguez" fill className="object-cover" />
              </div>
              <div>
                <h3 className="text-xl font-bold">Emily Rodriguez</h3>
                <p className="text-sm text-primary">Community Manager</p>
              </div>
              <p className="text-sm text-muted-foreground leading-relaxed">
                Building connections and fostering engagement within our growing community.
              </p>
            </Card>
          </div>
        </section>

        {/* CTA Section */}
        <section className="bg-gradient-to-br from-primary/5 via-accent/5 to-background py-16">
          <div className="container mx-auto px-4">
            <div className="max-w-2xl mx-auto text-center space-y-6">
              <h2 className="text-3xl md:text-4xl font-bold text-balance">Ready to Share Your Story?</h2>
              <p className="text-muted-foreground leading-relaxed">
                Join thousands of writers who are already sharing their insights and building their audience on Insight.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center pt-4">
                <Link href="/auth">
                  <Button size="lg">Get Started</Button>
                </Link>
                <Link href="/contact">
                  <Button size="lg" variant="outline">
                    Contact Us
                  </Button>
                </Link>
              </div>
            </div>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  )
}
