## Insight – Modern Blogging Platform

A fast, modern blogging platform built with Next.js App Router, React, and a polished UI. Ships with a home feed, post pages, categories, search, basic auth context, and editor/admin placeholders – all wired to mock data so you can develop instantly without a backend.

### Key Features
- **Modern UI**: Accessible components (Radix-based) and responsive Tailwind styles.
- **Home feed**: Featured story, category filter, and post grid.
- **Post page**: Hero image, author card, social share, comments section (mocked).
- **Search**: Command-style dialog with live filtering over mock posts.
- **Auth stubs**: Login/Signup forms with an in-memory auth context.
- **Editor/Admin**: Placeholder routes to expand into full features.
- **TypeScript**: Strong types for posts, categories, and comments.

### Performance Highlights
- **Server-rendered homepage**: The homepage is a server component; less client JS, faster TTFB.
- **Dynamic imports**: Search dialog loads on demand (kept out of initial bundle).
- **Image optimization**: Next/Image enabled with AVIF/WebP and correct `sizes`/`priority` where relevant.
- **Lean client state**: URL-based category filtering reduces client-side effect work.

---

## Getting Started

### Prerequisites
- Node.js 18.18+ (recommended 20+)
- One package manager: **PNPM 9+** or **NPM 10+**

Note: The repo contains both `pnpm-lock.yaml` and `package-lock.json`. Use only one package manager to avoid conflicts. If you choose PNPM, remove `package-lock.json`; if you choose NPM, remove `pnpm-lock.yaml`.

### Install
Using PNPM (recommended):
```bash
pnpm install
```

Or using NPM:
```bash
npm install
```

### Run in Development
```bash
# PNPM
pnpm dev

# NPM
npm run dev
```
App runs on `http://localhost:3000` by default.

### Build and Start (Production)
```bash
# Build
pnpm build      # or: npm run build

# Start production server
pnpm start      # or: npm run start
```

No environment variables are required by default; the app uses mock data from `lib/mock-data.tsx`.

---

## Scripts
- **dev**: Start the Next.js development server
- **build**: Create an optimized production build
- **start**: Start the production server
- **lint**: Run Next.js ESLint (errors are ignored during build per config)

```bash
pnpm dev | pnpm build | pnpm start | pnpm lint
# or npm run dev | npm run build | npm run start | npm run lint
```

---

## Project Structure
```
app/                 # App Router pages
  page.tsx          # Homepage (server component)
  post/[slug]/      # Individual post page
components/         # UI and feature components (header, footer, cards, search)
lib/                # Auth context and mock data
public/             # Static assets (images)
styles/             # Global styles
next.config.mjs     # Next.js configuration (image optimization enabled)
```

---

## Configuration & Customization
- **Mock content**: Edit `lib/mock-data.tsx` to change posts, categories, and comments.
- **Branding**: Update images in `public/` and texts/logo in `components/layout/header.tsx` and `components/layout/footer.tsx`.
- **Styling**: Tailwind utilities are used throughout; global styles live in `app/globals.css` and `styles/globals.css`.
- **Images**: `next.config.mjs` enables AVIF/WebP and the Image Optimization pipeline. When adding new images, set appropriate `sizes` and `priority` for above-the-fold content.

---

## Deployment
- Deploy to any Node/Next host (Vercel recommended). For Vercel, push to a Git repo and import – defaults are supported. See the [Vercel documentation](https://vercel.com/docs).
- For self-hosting, build with `npm run build` (or `pnpm build`) and run `npm start` (or `pnpm start`). Make sure your environment provides Node 18.18+.

---

## Troubleshooting
- **Port in use**: Change the port with `PORT=3001 npm run dev` (or set in your shell on Windows PowerShell: `$env:PORT=3001; npm run dev`).
- **Package manager conflicts**: Remove the lockfile of the manager you are not using.
- **Slow dev on Windows**: Prefer Node 20+, and consider using WSL 2 for large projects.

---

## Roadmap Ideas
- Connect to a real database and add APIs for posts/comments/auth.
- Rich text editor persistence for `/editor` routes.
- User profiles, author pages, pagination, and full-text search.



